<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "artist_data";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'artist_data/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Artist Panel', 'redux-framework-demo' ),
        'page_title'           => __( 'Artist Panel', 'redux-framework-demo' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['admin_bar_links'][] = array(
        'id'    => 'redux-docs',
        'href'  => 'http://docs.reduxframework.com/',
        'title' => __( 'Documentation', 'redux-framework-demo' ),
    );

    $args['admin_bar_links'][] = array(
        //'id'    => 'redux-support',
        'href'  => 'https://github.com/ReduxFramework/redux-framework/issues',
        'title' => __( 'Support', 'redux-framework-demo' ),
    );

    $args['admin_bar_links'][] = array(
        'id'    => 'redux-extensions',
        'href'  => 'reduxframework.com/extensions',
        'title' => __( 'Extensions', 'redux-framework-demo' ),
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://github.com/ReduxFramework/ReduxFramework',
        'title' => 'Visit us on GitHub',
        'icon'  => 'el el-github'
        //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/pages/Redux-Framework/243141545850368',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/reduxframework',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://www.linkedin.com/company/redux-framework',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'redux-framework-demo' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'redux-framework-demo' );
    }

    // Add content after the form.
    $args['footer_text'] = __( '<p>This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.</p>', 'redux-framework-demo' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'redux-framework-demo' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'redux-framework-demo' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'redux-framework-demo' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'redux-framework-demo' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'redux-framework-demo' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

    Redux::setSection( $opt_name, array(
                'icon'      => 'el-icon-cogs',
                'title'     => __('General Settings', 'artist_framework'),
                'fields'    => array(
                    array(
                        'id'        => 'artist_faviconurl',
                        'type'      => 'media',
						'preview'   => false,
                        'title'     => __('Custom Favicon', 'artist_framework'),
                        'desc'      => __('Upload a 16px x 16px Png/Gif image that will represent your website\'s favicon.', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                    ),
					array(
						'id'        => 'artist_weblogo',
                        'type'      => 'media',
                        'title'     => __('Website Logo', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        'subtitle'  => __('Upload your Logo Image.', 'artist_framework'),
					),
					array(
                        'id'        => 'artist_sidebarposition',
                        'type'      => 'image_select',
                        'compiler'  => true,
                        'title'     => __('Sidebar Position', 'artist_framework'),
                        'subtitle'  => __('Select main content and sidebar alignment.', 'artist_framework'),
                        'options'   => array(
                            '1' => array('alt' => '1 Column',       'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
                            '2' => array('alt' => '2 Column Left',  'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
                            '3' => array('alt' => '2 Column Right', 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
                        ),
                        'default'   => '3'
                    ),
					array(
						'id'        => 'artist_copyrighttext',
						'type'      => 'text',
						'title'     => __('Copyright Text', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('', 'artist_framework')
					),
					array(
                        'id'        => 'artist_googleanalytics',
                        'type'      => 'textarea',
                        'title'     => __('Tracking Code (Google Analytics)', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Paste your Google Analytics (or other) tracking code here. This will be added into the footer template of your theme.', 'artist_framework')
                    )
                )
            )
		);
		
		Redux::setSection( $opt_name, array(
                'icon'      => 'el-icon-user',
                'title'     => __('Author Settings', 'artist_framework'),
                'fields'    => array(
					array(
                        'id'        => 'artist_authorswitch',
                        'type'      => 'switch',
                        'title'     => __('Author Section On or Off', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'default'   => true,
                    ),
                    array(
						'id'        => 'artist_authorname',
						'type'      => 'text',
						'title'     => __('Author\'s Name', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('', 'artist_framework')
					),
					 array(
						'id'        => 'artist_authordesignation',
						'type'      => 'text',
						'title'     => __('Author\'s Designation', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('', 'artist_framework')
					),
					 array(
						'id'        => 'artist_authorabout',
						'type'      => 'textarea',
						'title'     => __('Author\'s About Yourself', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('', 'artist_framework')
					),
					array(
                        'id'        => 'artist_authorimg',
                        'type'      => 'media',
                        'title'     => __('Author\'s Image', 'artist_framework'),
                        'desc'      => __('Upload author image that will represent your website\'s.', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                    ),
					array(
                        'id'        => 'artist_authorsharing',
                        'type'      => 'checkbox',
                        'title'     => __('Choose Social Icon', 'artist_framework'),
                        'subtitle'  => __('Share Your Info on social sites.', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        
                        //Must provide key => value pairs for multi checkbox options
                        'options'   => array(
                            'facebook' => 'facebook', 
                            'twitter' => 'twitter', 
                            'googleplus' => 'googleplus'
                        )
					),
					array(
						'id'        => 'artist_authorsharingtext',
						'type'      => 'text',
						'title'     => __('Sharing Related Text', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('', 'artist_framework')
					)
                )
            )
		);
		Redux::setSection( $opt_name, array(
                'icon'      => 'glyphicon el-icon-stop-alt',
                'title'     => __('Slider', 'artist_framework'),
                'fields'    => array(
					array(
                        'id'        => 'artist_sliderswitch',
                        'type'      => 'switch',
                        'title'     => __('Home Page Slider On or Off', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'default'   => true,
                    ),
					array(
                        'id'        => 'artist_slider_title_desc_switch',
                        'type'      => 'switch',
                        'title'     => __('Show Title Or Description', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'default'   => false,
                    ),
					array(
                        'id'        => 'artist_radioselect',
                        'type'      => 'radio',
                        'title'     => __('Choose Option For Image Selection', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                         //Must provide key => value pairs for radio options
                        'options'   => array(
                            '1' => 'Featured Portfolio', 
                            '2' => 'Custom Creation'
                        ),
                        'default'   => '1'
                    ),
					array(
                        'id'        => 'artist_slides',
                        'type'      => 'slides',
						'required'  => array('artist_radioselect', '=', '2'),
                        'title'     => __('Slides Options', 'artist_framework'),
                        'subtitle'  => __('Unlimited slides with drag and drop sorting.', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        'placeholder'   => array(
                            'title'         => __('This is a title', 'artist_framework'),
                            'description'   => __('Description Here', 'artist_framework'),
                            'url'           => __('Give us a link!', 'artist_framework'),
                        ),
                    ),
					array(
						'id'        => 'artist_no_of_portfoliopost',
						'type'      => 'text',
						'required'  => array('artist_radioselect', '=', '1'),
						'title'     => __('Latest No Of Post', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('', 'artist_framework')
					),
					 array(
                        'id'    => 'artist_info_slidescode',
                        'type'  => 'info',
                        'style' => 'warning',
                        'title' => __('Use this shortcode.', 'redux-framework-demo'),
                        'desc'  => __('[Artist-slider]', 'artist_framework')
                    )
				)
			)
		);
		Redux::setSection( $opt_name, array(
                'icon'      => 'el-icon-tint',
                'title'     => __('Styling Options', 'artist_framework'),
                'fields'    => array(
					/*array(
                        'id'        => 'artist_selectstylesheet',
                        'type'      => 'select',
                        'title'     => __('Theme Stylesheet', 'artist_framework'),
                        'subtitle'  => __('Select your themes alternative color scheme.', 'artist_framework'),
                        'options'   => array('default.css' => 'default.css', 'color1.css' => 'color1.css'),
                        'default'   => 'default.css',
                    ),*/
					array(
                        'id'        => 'artist_bodybackground',
                        'type'      => 'background',
                        'output'    => array('body'),
                        'title'     => __('Body Background', 'artist_framework'),
                        'subtitle'  => __('Body background with image, color, etc.', 'artist_framework'),
                        'default'   => '',
                    ),
					array(
                        'id'        => 'artist_typographybodytext',
                        'type'      => 'typography',
						'output'    => array('body'),
                        'title'     => __('Body Font', 'artist_framework'),
                        'subtitle'  => __('Specify the body font properties.', 'artist_framework'),
                        'google'    => true,
                        'default'   => array(
                            'color'         => '',
                            'font-size'     => '',
                            'font-family'   => '',
                            'font-weight'   => '',
                        ),
                    ),
					array(
                        'id'        => 'artist_typographybodyheading',
                        'type'      => 'typography',
						'output'    => array('h1,h2,h3,h4,h5,h6'),
                        'title'     => __('Body Heading H1-H6 Font', 'artist_framework'),
                        'subtitle'  => __('Specify the Heading font properties.', 'artist_framework'),
                        'google'    => true,
                        'default'   => array(
                            'color'         => '',
                            'font-size'     => '',
                            'font-family'   => '',
                            'font-weight'   => '',
                        ),
                    ),
					array(
                        'id'        => 'artist_customcss',
                        'type'      => 'ace_editor',
						'mode'      => 'css',
						'theme'     => 'monokai',
                        'title'     => __('Custom CSS', 'artist_framework'),
                        'subtitle'  => __('Quickly add some CSS to your theme by adding it to this block.', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        'validate'  => 'css',
						'default'   => '',
                    )
                )
            )
		);
		
		Redux::setSection( $opt_name, array(
                'icon'      => 'el-icon-twitter',
                'title'     => __('Social Setting', 'artist_framework'),
                'fields'    => array(
					array(
						'id'        => 'artist_facebookurl',
						'type'      => 'text',
						'title'     => __('<img src="'.ARTIST_PATH.'/images/facebook.png"', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('Enter Facebook Url.', 'artist_framework')
					),
					array(
						'id'        => 'artist_twitterurl',
						'type'      => 'text',
						'title'     => __('<img src="'.ARTIST_PATH.'/images/twitter.png"', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('Enter Twitter Url.', 'artist_framework')
					),
					array(
						'id'        => 'artist_linkedinurl',
						'type'      => 'text',
						'title'     => __('<img src="'.ARTIST_PATH.'/images/linkedin.png"', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('Enter Linkedin Url.', 'artist_framework')
					),
					array(
						'id'        => 'artist_flickrurl',
						'type'      => 'text',
						'title'     => __('<img src="'.ARTIST_PATH.'/images/flickr.png"', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('Enter Flickr Url.', 'artist_framework')
					),
					array(
						'id'        => 'artist_youtubeurl',
						'type'      => 'text',
						'title'     => __('<img src="'.ARTIST_PATH.'/images/youtube.png"', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('Enter Youtube Url.', 'artist_framework')
					),
					array(
						'id'        => 'artist_dribbbleurl',
						'type'      => 'text',
						'title'     => __('<img src="'.ARTIST_PATH.'/images/dribbble.png"', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('Enter Dribbble Url.', 'artist_framework')
					),
					array(
						'id'        => 'artist_deliciousurl',
						'type'      => 'text',
						'title'     => __('<img src="'.ARTIST_PATH.'/images/delicious.png"', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('Enter Delicious Url.', 'artist_framework')
					)
				)
			)
		);
		
		Redux::setSection( $opt_name, array(
                'icon'      => 'el-icon-tasks',
                'title'     => __('Footer Setting', 'artist_framework'),
                'fields'    => array(
					 array(
                        'id'        => 'artist_footerlayout',
                        'type'      => 'image_select',
                        'title'     => __('Footer Layout', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),                        
                        //Must provide key => value(array:title|img) pairs for radio options
                        'options'   => array(
                            'firstcolumn' => array('alt' => '1 Column',        'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
                            'secondcolumn' => array('alt' => '2 Column Right',  'img' => ReduxFramework::$_url . 'assets/img/Footercol2.png'),
                            'thirdcolumn' => array('alt' => '3 Column Middle', 'img' => ReduxFramework::$_url . 'assets/img/Footercol3.png')
                        ), 
                        'default' => 'firstcolumn'
                    ),
					array(
                        'id'    => 'artist_infowarning',
                        'type'      => 'info',
                        'notice'    => true,
                        'style'     => 'critical',
                        'icon'      => 'el-icon-info-sign',
                        'title'     => __('Advice.', 'artist_framework'),
                        'desc'      => __('If you select full layout of footer, then need to select First Column, &amp; If you go for 2 Column , then choose First &amp; Second Column, &amp; for 3 Column , choose all 3 options.', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_selectfooter1',
                        'type'      => 'select',
                        'title'     => __('First column', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        //Must provide key => value pairs for select options
                        'options'   => array(
                            'FooterColumn1' => 'Footer Column1', 
                            'FooterColumn2' => 'Footer Column2', 
                            'FooterColumn3' => 'Footer Column3'
                        ),
						'default' => 'FooterColumn1'
                    ),
					array(
                        'id'        => 'artist_selectfooter2',
                        'type'      => 'select',
                        'title'     => __('Second column', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        //Must provide key => value pairs for select options
                        'options'   => array(
                            'FooterColumn1' => 'Footer Column1', 
                            'FooterColumn2' => 'Footer Column2', 
                            'FooterColumn3' => 'Footer Column3'
                        )
                    ),
					array(
                        'id'        => 'artist_selectfooter3',
                        'type'      => 'select',
                        'title'     => __('Third column', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        //Must provide key => value pairs for select options
                        'options'   => array(
                            'FooterColumn1' => 'Footer Column1', 
                            'FooterColumn2' => 'Footer Column2', 
                            'FooterColumn3' => 'Footer Column3'
                        )
                    )
				)
			)
		);
		
		Redux::setSection( $opt_name, array(
                'icon'      => 'el-icon-group',
                'title'     => __('Partners', 'artist_framework'),
                'fields'    => array(
					array(
						'id'        => 'artist_partnertitle',
						'type'      => 'text',
						'title'     => __('Title', 'artist_framework'),
						'subtitle'  => __('', 'artist_framework'),
						'desc'      => __('', 'artist_framework')
					),
					array(
                        'id'        => 'artist_partnerslides',
                        'type'      => 'slides',
                        'title'     => __('Partner Slides Options', 'artist_framework'),
                        'subtitle'  => __('Unlimited slides with drag and drop sortings.', 'artist_framework'),
                        'desc'      => __('', 'artist_framework'),
                        'placeholder'   => array(
                            'title'         => __('This is a title', 'artist_framework'),
                            'description'   => __('Description Here', 'artist_framework'),
                            'url'           => __('Give us a link!', 'artist_framework'),
                        ),
                    ),
					 array(
                        'id'    => 'artist_info_partnerinfo',
                        'type'  => 'info',
                        'style' => 'warning',
                        'title' => __('Use this shortcode.', 'redux-framework-demo'),
                        'desc'  => __('[Artist-Partner-Slider]', 'artist_framework')
                    )
				)
			)
		);
 
 		Redux::setSection( $opt_name, array(
                'icon'      => 'el-icon-map-marker',
                'title'     => __('Contact Setting', 'artist_framework'),
                'fields'    => array(
					array(
                        'id'        => 'artist_contactemailaddrs',
                        'type'      => 'text',
                        'title'     => __('Email Address', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Enter your email address', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_mailsubject',
                        'type'      => 'text',
                        'title'     => __('Mail Subject', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Enter subject for reciveing mail', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_recievemailaddrs',
                        'type'      => 'text',
                        'title'     => __('Received Name', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Enter your name for reciveing address', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_successmessage',
                        'type'      => 'text',
                        'title'     => __('Success Message', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Success message text after email delivered', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_contactmaponoff',
                        'type'      => 'switch',
                        'title'     => __('Enable OR Disable Contact Map', 'artist_framework'),
                        'subtitle'  => __('Switch ON to enable contact map, Switch OFF to disable it. ;)', 'artist_framework'),
                        //'options' => array('on', 'off'),
                        'default'   => true,
                    ),
					array(
                        'id'        => 'artist_Latitude_Longitude',
                        'type'      => 'text',
                        'title'     => __('Google Map Latitude & Longitude ', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Eg. : 22.962267, 76.050795', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_maptitle',
                        'type'      => 'text',
                        'title'     => __('Map Title On Highlights', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_addrstitle',
                        'type'      => 'text',
                        'title'     => __('Address Title', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_contactphone',
                        'type'      => 'text',
                        'title'     => __('Phone No.', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Eg. : 91. 123. 456. 7890, 91. 123. 456. 7890', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_contactemail',
                        'type'      => 'text',
                        'title'     => __('Email Address', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Eg. : admin@artistpsd.com,info@artistpsd.com', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_contactaddress',
                        'type'      => 'textarea',
                        'title'     => __('Home Address', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('Eg. : 121 King St ,Melbourne VIC 3000','artist_framework')
                    ),
					array(
                        'id'        => 'artist_formtitle',
                        'type'      => 'text',
                        'title'     => __('Form Title', 'artist_framework'),
                        'subtitle'  => __('', 'artist_framework'),
                        'desc'      => __('', 'artist_framework')
                    ),
					array(
                        'id'        => 'artist_fieldsenable_disable',
                        'type'      => 'sorter',
                        'title'     => 'Form Setting',
                        'subtitle'  => 'You can choose INPUT fields.',
                        'compiler'  => 'true',
                        'options'   => array(
                            'ENABLE'   => array(
                                'NAME'    => 'NAME',
                                'PHONENUMBER'    => 'PHONE NUMBER',
                                'EMAIL'        => 'EMAIL',
                                'WEBSITE'        => 'WEBSITE',
                                'MESSAGE'    => 'MESSAGE'
                            ),
							'DISABLE' => array(
							
							)
                        )
                    ), 
					array(
                        'id'        => 'artist_fieldsrequire',
                        'type'      => 'sorter',
                        'title'     => 'Required Field',
                        'subtitle'  => 'You can choose INPUT fields REQUIRED or NOT.',
                        'compiler'  => 'true',
                        'options'   => array(
                            'REQUIRE'   => array(
                                'NAME'    => 'NAME',
                                'PHONENUMBER'    => 'PHONE NUMBER',
                                'EMAIL'        => 'EMAIL',
                                'WEBSITE'        => 'WEBSITE',
                                'MESSAGE'    => 'MESSAGE'
                            ),
							'NOT REQUIRE' => array(
							
							)
                        )
                    )
				)
			)
		);
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = 'your custom error message';
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = 'your custom warning message';
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'redux-framework-demo' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'redux-framework-demo' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

