<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package Artist
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<?php if ( have_comments() ) : ?>
			<?php
				printf( _nx( '<div class="span12 hs_comment_related wow fadeInLeft"><h1 class="lined">Comments (%1$s)</h1> </div>', '<div class="span12 hs_comment_related wow fadeInLeft"><h1 class="lined">Comments (%1$s)</h1> </div>', get_comments_number(), 'comments title', 'artist' ),
					number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
			?>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-above" class="comment-navigation" role="navigation">
			<h1 class="screen-reader-text"><?php _e( 'Comment navigation', 'artist' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'artist' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'artist' ) ); ?></div>
		</nav><!-- #comment-nav-above -->
		<?php endif; // check for comment navigation ?>

			<?php
				wp_list_comments( 'type=comment&callback=artist_custom_comments' );
			?>
		<!-- .comment-list -->

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-below" class="comment-navigation" role="navigation">
			<h1 class="screen-reader-text"><?php _e( 'Comment navigation', 'artist' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'artist' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'artist' ) ); ?></div>
		</nav><!-- #comment-nav-below -->
		<?php endif; // check for comment navigation ?>

	<?php endif; // have_comments() ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php _e( 'Comments are closed.', 'artist' ); ?></p>
	<?php endif; ?>
<div class="row-fluid">
<?php 
$commenter = wp_get_current_commenter();
$aria_req = ( $req ? " aria-required='true'" : '' );
$fields =  array(
    'author' => '<div class="span6 hs_top_fifty"><input type="text" id="author" placeholder="Your Name" name="author" class="span12 hs_comment_input wow bounceInDown" value="' . esc_attr( $commenter['comment_author'] ).'" ' . $aria_req .'  />',
		
    'email'  => '<input type="text" id="email" value="' . esc_attr( $commenter['comment_author_email'] ).'" ' . $aria_req .'" placeholder="Your Email" name="email" class="span12 hs_comment_input wow bounceInDown hs_delay_02" /></div>'
);
$comments_args = array(
    'fields' =>  $fields,
	'id_form'           => 'artist_commentform',
  'comment_field'         => '<div class="span6 hs_top_fifty">
		<textarea name="comment" id="comment" placeholder="Message" class="span12 hs_blog_comment wow bounceInDown hs_delay_04">
		</textarea>
	  </div>',
  'comment_notes_before'=>'',
  'comment_notes_after'=>'',
  'id_submit'=>'commentsubmit',
  'label_submit'=>'Send Message',
  'title_reply'=>'<div class="span12 hs_line_comment wow fadeInLeft">
        <h1 class="lined"> Leave a Comment </h1>
      </div>',  
);
comment_form($comments_args); ?>
</div><!-- #comments -->