<?php
/***********============= Woocommerce =============***********/
if ( class_exists( 'WooCommerce' ) ) {
	
	remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
	remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
	remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10); 
	add_action( 'woocommerce_before_shop_loop_item_title', 'woo_artist_loop_product_thumbnail', 10); 
	
	if(!function_exists('woo_artist_sidebar')){ 
		function woo_artist_sidebar(){
			echo '<div class="span4 artist_sidebar"><div id="secondary" class="widget-area" role="complementary">';
				dynamic_sidebar( 'artist_woo_sidebar' );
			echo '</div></div>';
		}
	} 
	
	if(!function_exists('woo_artist_loop_product_thumbnail')){ 
		function woo_artist_loop_product_thumbnail($size = 'shop_catalog', $placeholder_width = 0, $placeholder_height = 0){
			global $post, $woocommerce;

			$size = wc_get_image_size( 'shop_catalog' );
				
			$output = '<div class="shop_port_thumb"><div class="shop_latest">';

			if ( has_post_thumbnail() ) {
				$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
				$url = $thumb[0];
				$url = aq_resize($url, $size['width'], $size['height'],true);
				$output .= '<img src="'. esc_url($url) .'" alt="" width="' . $size['width'] . '" height="' . $size['height'] . '" />';			
			} else {
				$placeholder_width = $size['width'];
				$placeholder_height = $size['height'];
				$output .= '<img src="'. woocommerce_placeholder_img_src() .'" alt="Placeholder" width="' . $placeholder_width . '" height="' . $placeholder_height . '" />';
			}
			
			$output .= '</div></div>';
			
			echo $output;
		}
	}
	
	if(!function_exists('artist_woo_the_breadcrumb')){ 
		function artist_woo_the_breadcrumb($title) {
			$src = esc_url(get_template_directory_uri().'/images/seprator.png');
			echo '<!-- Breadcrumb-Start -->
		<div class="row-fluid">
		  <div class="span12">
			<div class="span12 hs_left hs_heading_part"> 
				<img src="'.esc_url($src).'" alt="seprator"/> </div>
			<div class="span12 hs_left">';
			if ( apply_filters( 'woocommerce_show_page_title', true ) ){
			echo '<div class="span7 hs_inner_heading wow fadeInDown">
				<h1> '.esc_attr($title).' </h1>
			  </div>';
			}
			 echo ' <div class="span5 hs_breadcrumb_part hs_left">';
				$args = array(
					'delimiter'   => '',
					'wrap_before' => '<ul class="hs_breadcrumb">',
					'wrap_after'  => '</ul>',
					'before'      => '<li>',
					'after'       => '</li>',
					'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
				);
				woocommerce_breadcrumb($args);
				echo '</div>
			</div>
			<div class="span12 hs_left hs_heading_part"> 
			  <img src="'.$src.'" alt="seprator"/> 
			</div>
		  </div>
		</div>';
		}
	}
}
/***********============= Woocommerce =============***********/


/***********============= Ajax Send Mail =============***********/
add_action( 'wp_ajax_artist_sndadminmail', 'artist_sndadminmail' );
add_action( 'wp_ajax_nopriv_artist_sndadminmail', 'artist_sndadminmail' );
function artist_sndadminmail(){
	global $artist_data;
	$message = '';
	$to = $artist_data['artist_contactemailaddrs'];
	$reciveaddrs = $artist_data['artist_recievemailaddrs'];
	$mailsub = $artist_data['artist_mailsubject'];
	if(isset($_POST['name'])){
		$nm = $_POST['name'];
		$message .= "NAME : ".$_POST['name']."\n";
	}
	if(isset($_POST['email'])){
		$email = $_POST['email'];
		$message .= "EMAIL : ".$_POST['email']."\n";
	}
	if(isset($_POST['phono'])){
		$phone = $_POST['phono'];
		$message .= "NUMBER : ".$_POST['phono']."\n";
	}
	if(isset($_POST['web'])){
		$web = $_POST['web'];
		$message .= "WEB : ".$_POST['web']."\n";
	}
	if(isset($_POST['Message'])){
		$meg = $_POST['Message'];
		$message .= "MESSAGE : ".$_POST['Message'];
	}
	$message .= "\n\n";
$host = $_SERVER['HTTP_HOST'];
preg_match("/[^\.\/]+\.[^\.\/]+$/", $host, $matches);
	$header = "From: ".$reciveaddrs."@".$matches[0]."\r\n"; 
	$header.= "MIME-Version: 1.0\r\n"; 
	$header.= "Content-Type: text/plain; charset=utf-8\r\n"; 
	$header.= "X-Priority: 1\r\n"; 
	$sub = $mailsub;
	if(mail($to,$sub,$message,$header)){
		echo $meg = $artist_data['artist_successmessage'];
	}
	else{
		echo $meg = "Sorry. your mail has not been send successfully."; 
	}
	die();
}

/***********============= comments section =============***********/
function artist_custom_comments($comment, $args, $depth){
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
	<<?php echo $tag ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
		<div class="span12 hs_comment_post hs_left wow fadeInDown"> <a href="<?php echo get_comment_link(); ?>">
        <div class="span2 hs_blog_thumb hs_comment_avtar">
          <div class="span12 hs_bloging "> <?php echo get_avatar($comment,$size='174') ?> </div>
        </div>
        </a>
        <div class="span8 hs_single_title"> <a href="<?php echo get_comment_link(); ?>"> <?php _e($comment->comment_author,'artist'); ?> </a> </div>
        <div class="span8 hs_author_tag"> <a href="<?php echo get_comment_link(); ?>"> <?php _e(human_time_diff( strtotime($comment->comment_date), strtotime(date('Y-m-d H:i:s')) ).' Ago','artist') ?> </a> </div>
        <div class="span8">
		<?php if ( $comment->comment_approved == '0' ) { ?>
		<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.','artist' ); ?></em>
		<br />
		<?php }else{ ?>		
		<?php _e( comment_text(), 'artist' ); } ?> </div>
        <div class="span2 blog_comment_reply_btn reply"><?php comment_reply_link( array_merge( $args, array(  'add_below' => $add_below,'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?> </div>
      </div>	
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; 
}

/***********============= custom css =============***********/
if(!is_admin()){
	add_action('wp_head','customcss_artistoption');
	function customcss_artistoption(){
		global $artist_data;
		$css = $artist_data['artist_customcss'];
		$css_output = "<!-- Custom CSS -->\n<style type=\"text/css\">\n" . $css . "\n</style>";
		if(!empty($css)) {
			echo $css_output;
		}
	}
}

/***********============= breadcrumb =============***********/
if(!function_exists('artist_the_breadcrumb')){
	function artist_the_breadcrumb($title = null) {
		global $post;
		$src = esc_url(get_template_directory_uri().'/images/seprator.png');
		echo '<!-- Breadcrumb-Start -->
<div class="row-fluid">
  <div class="span12">
    <div class="span12 hs_left hs_heading_part"> 
		<img src="'.esc_url($src).'" alt="seprator"/> </div>
    <div class="span12 hs_left">
      <div class="span7 hs_inner_heading wow fadeInDown">
        <h1> '.esc_attr($title).' </h1>
      </div>
      <div class="span5 hs_breadcrumb_part hs_left">';
		echo '<ul class="hs_breadcrumb">';
		if (!is_home()) {
			echo '<li><a href="';
			echo home_url();
			echo '">';
			echo 'Home';
			echo '</a></li>';
			if (is_category() || is_single()) {
				echo '<li>';
				$arr = get_the_category($post->ID);
				if(empty($arr)){
					$href = esc_url(site_url().'/?post_type='.get_post_type($post->ID));
					echo '<a href="'.$href.'">'.__(esc_attr(get_post_type($post->ID)),'artist').'</a>';
				}else{
					the_category(' </li><li> ');
				}
				if (is_single()) {
					echo '</li><li>';
					the_title();
					echo '</li>';
				}
			} elseif (is_page()) {
				if($post->post_parent){
					$anc = get_post_ancestors( $post->ID );
					$title = get_the_title();
					foreach ( $anc as $ancestor ) {
						$output = '<li><a href="'.esc_url(get_permalink($ancestor)).'" title="'.esc_attr(get_the_title($ancestor)).'">'.__(esc_attr(get_the_title($ancestor)),'artist').'</a></li> ';
					}
					echo $output;
					echo '<strong title="'.esc_attr($title).'"> '.__(esc_attr($title),'artist').'</strong>';
				} else {
					echo '<li><strong> '.__(get_the_title(),'artist').'</strong></li>';
				}
			}
		}
		elseif (is_tag()) {single_tag_title();}
		elseif (is_day()) {echo"<li>Archive for "; the_time('F jS, Y'); echo'</li>';}
		elseif (is_month()) {echo"<li>Archive for "; the_time('F, Y'); echo'</li>';}
		elseif (is_year()) {echo"<li>Archive for "; the_time('Y'); echo'</li>';}
		elseif (is_author()) {echo"<li>Author Archive"; echo'</li>';}
		elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<li>Blog Archives"; echo'</li>';}
		elseif (is_search()) {echo"<li>Search Results"; echo'</li>';}
		echo '</ul>';
		echo '</div>
    </div>
    <div class="span12 hs_left hs_heading_part"> 
      <img src="'.$src.'" alt="seprator"/> 
    </div>
  </div>
</div>';
	}
}

/***********============= edit excerpt =============***********/
if(!function_exists('get_excerpt')){
	function get_excerpt($count){
	  global $post;
	  $permalink = get_permalink($post->ID);
	  $excerpt = get_the_content();
	  $excerpt = strip_tags($excerpt);
	  $excerpt = substr($excerpt, 0, $count);
	  $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
	  $excerpt = $excerpt.'... ';
	  return $excerpt;
	}
}

/***********============= Post Navigation =============***********/
add_filter('next_posts_link_attributes', 'posts_link_attributes');
add_filter('previous_posts_link_attributes', 'posts_link_attributes');
if(!function_exists('posts_link_attributes')){
	function posts_link_attributes() {
		return 'class="styled-button"';
	}
}

/***********============= Search Box =============***********/ 
if(!function_exists('artist_search_form')){
	function artist_search_form( $form ) {
		$form = '<form role="search" method="get" id="searchform" class="searchform artist_margin_top_50" action="' . home_url( '/' ) . '" >
		<div><label class="screen-reader-text" for="s">' . __( 'Search for:' ,'artist' ) . '</label>
		<input type="text" id="s" value="'.get_search_query().'" placeholder="Search" name="s" class="span8 hs_search_input"/>
		<input type="submit" id="searchsubmit" style="visibility: hidden;" value="'. esc_attr__( 'Search' ) .'" />
		</div>
		</form>';

		return $form;
	}
}
add_filter( 'get_search_form', 'artist_search_form' );

/***********============= Wp-Admin Logo =============***********/ 
if(!function_exists('artist_adminloginlogoimg')){
	function artist_adminloginlogoimg() {
	global $artist_data;
	$sitelogo = ''; 
	$sitelogo = $artist_data['artist_weblogo']['url']; 
	if (empty($sitelogo)) { $sitelogo = ARTIST_PATH.'/images/logo.png'; }	
	echo '<style type="text/css">
	body.login div#login h1 a {
	background-image: url('.$sitelogo.');
	background-size: 100% 100%;
	height: 0;
	margin: 0 auto 0;
	width: 237px;
	height: 85px;
	}
	}
	</style>';
	}
}
add_action( 'login_enqueue_scripts', 'artist_adminloginlogoimg' );
?>