<?php

require_once ECWID_SHORTCODES_DIR . '/class-ecwid-shortcode-base.php';

class Ecwid_Shortcode_ProductBrowser extends Ecwid_Shortcode_Base {

	public function get_shortcode_name() {
		return 'productbrowser';
	}

	protected function _get_html_class_name() {
		return 'product-browser';
	}

	public function get_html_id() {
		return 'ecwid-store-' . get_ecwid_store_id();
	}

	public function get_ecwid_widget_function_name() {
		return 'xProductBrowser';
	}

	public function render() {
		return parent::render();
	}

	public function render_placeholder( ) {

		$store_id = get_ecwid_store_id();

		$plain_content = '';

		if (ecwid_can_display_html_catalog()) {
			$params = ecwid_parse_escaped_fragment($_GET['_escaped_fragment_']);
			include_once ECWID_PLUGIN_DIR . 'lib/ecwid_product_api.php';
			include_once ECWID_PLUGIN_DIR . 'lib/ecwid_catalog.php';

			$page_url = get_page_link();

			$catalog = new EcwidCatalog($store_id, $page_url);

			$url = false;

			if (isset($params['mode']) && !empty($params['mode'])) {
				if ($params['mode'] == 'product') {
					$plain_content = $catalog->get_product($params['id']);
					$url = ecwid_get_product_url(ecwid_new_product_api()->get_product($params['id']));
				} elseif ($params['mode'] == 'category') {
					$plain_content = $catalog->get_category($params['id']);
					$url = ecwid_get_category_url(ecwid_new_product_api()->get_category($params['id']));
				}

			} else {
				$id = intval($this->_get_param_default_category_id($params));
				$plain_content = $catalog->get_category($id);
				if (empty($plain_content)) {
					$plain_content = $catalog->get_category(0);
				} else {
					$url = ecwid_get_category_url(ecwid_new_product_api()->get_category($params['id']));
				}
			}

			if ($url) {
				$parsed = parse_url($url);
				$plain_content .= '<script data-cfasync="false" type="text/javascript"> if (!document.location.hash) document.location.hash = "'. $parsed['fragment'] . '";</script>';
			}
		}

		$classname = $this->_get_html_class_name();
		$result = <<<HTML
		<div id="ecwid-store-$store_id" class="ecwid-shopping-cart-$classname">
		{$plain_content}
	</div>
HTML;

		return $result;
	}

	protected function _process_params( $shortcode_params = array() ) {

		$atts = shortcode_atts(
			array(
				'categories_per_row' => false,
				'grid' => false,
				'list' => false,
				'table' => false,
				'search_view' => false,
				'category_view' => false
			), $shortcode_params
		);

		$grid = explode(',', $atts['grid']);
		if (count($grid) == 2) {
			$atts['grid_rows'] = intval($grid[0]);
			$atts['grid_cols'] = intval($grid[1]);
		} else {
			list($atts['grid_rows'], $atts['grid_cols']) = array(false, false);
		}

		$list_of_views = array('list','grid','table');

		$cats_per_row = $atts['categories_per_row'] ? $atts['categories_per_row'] : get_option('ecwid_pb_categoriesperrow');
		$products_per_column_in_grid = $atts['grid_rows'] ? $atts['grid_rows'] : get_option('ecwid_pb_productspercolumn_grid');
		$products_per_row_in_grid = $atts['grid_cols'] ? $atts['grid_cols'] : get_option('ecwid_pb_productsperrow_grid');
		$products_in_list = $atts['list'] ? $atts['list'] : get_option('ecwid_pb_productsperpage_list');
		$products_in_table = $atts['table'] ? $atts['table'] : get_option('ecwid_pb_productsperpage_table');
		$default_view = $atts['category_view'] ? $atts['category_view'] : get_option('ecwid_pb_defaultview');
		$search_view = $atts['search_view'] ? $atts['search_view'] : get_option('ecwid_pb_searchview');

		$ecwid_default_category_id = $this->_get_param_default_category_id( $shortcode_params );

		$store_id = get_ecwid_store_id();

		if (empty($cats_per_row)) {
			$cats_per_row = 3;
		}
		if (empty($products_per_column_in_grid)) {
			$products_per_column_in_grid = 3;
		}
		if (empty($products_per_row_in_grid)) {
			$products_per_row_in_grid = 3;
		}
		if (empty($products_in_list)) {
			$products_in_list = 10;
		}
		if (empty($products_in_table)) {
			$products_in_table = 20;
		}

		if (empty($default_view) || !in_array($default_view, $list_of_views)) {
			$default_view = 'grid';
		}
		if (empty($search_view) || !in_array($search_view, $list_of_views)) {
			$search_view = 'list';
		}

		$input_params = array(
			'categoriesPerRow' => $cats_per_row,
			'views' => "grid($products_per_column_in_grid,$products_per_row_in_grid) list($products_in_list) table($products_in_table)",
			'categoryView' => $default_view,
			'searchView' => $search_view,
			'id' => "ecwid-store-$store_id"
		);

		if ($ecwid_default_category_id) {
			$input_params['defaultCategoryId'] = $ecwid_default_category_id;
		}

		$this->_params = $input_params;
	}

	/**
	 * @param $shortcode_params
	 *
	 * @return mixed|void
	 */
	protected function _get_param_default_category_id( $shortcode_params ) {
		$ecwid_default_category_id =
			! empty( $shortcode_params ) && array_key_exists( 'default_category_id', $shortcode_params )
				? $shortcode_params['default_category_id']
				: get_option( 'ecwid_default_category_id' );

		return $ecwid_default_category_id;
	}
}