<?php
/*
 * Start Services MetaBox Option
 */
$prefix = 'artist_';
$servicessection_option_meta = array(
    'id' => 'servicespage-section-meta',
    'title' => __('Services section settings','artist'),
    'page' => 'services',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
	   array(
            'name' => __('Select Icon Font', 'artist'),
            'desc' => __('Choose a font for representing your services.', 'artist'),
            'id' => $prefix.'service_iconfont',
            "type" => "font",
            'std' => '1'
        ),
		 array(
            'name' => __('', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'service_blank',
            "type" => "blank"
        ),
       array(
            'name' => __('Icon Image', 'artist'),
            'desc' => __('Choose an icon image for this section.', 'artist'),
            'id' => $prefix.'service_bg_image',
            "type" => "text",
            'std' => ''
        ),
        array(
            'name' => '',
            'desc' => '',
            'id' => $prefix.'section_bg_image_button',
            'type' => 'button',
            'std' => 'Browse'
        )
	)		
);
// create boxes for home sections
add_action('admin_menu', 'add_service_section_meta_boxes');
function add_service_section_meta_boxes(){
    global  $servicessection_option_meta;
    add_meta_box($servicessection_option_meta['id'], $servicessection_option_meta['title'], 'services_show_section_options', $servicessection_option_meta['page'], $servicessection_option_meta['context'], $servicessection_option_meta['priority']);
} 
function services_show_section_options(){
    global $servicessection_option_meta, $post;
    // Use nonce for verification
    echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
    echo '<table class="form-table">';
    foreach ($servicessection_option_meta['fields'] as $field) {
        // get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        switch ($field['type']) {
            case 'text':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
                    : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
            case 'button':
                echo '<input style="float: left;" type="button" class="button" name="', $field['id'], '" id="', $field['id'], '" value="Browse" />';
				echo '<span style="text-align: center;float: left;font-size: 14px;color: #999;margin-top: 5px;">Icon best size 100 * 100</span>';
				echo '<div style="float: right;margin-top: -40px;">';
				if(!empty($meta))
					echo '<img src="'.$meta.'" width="50" height="50" class="artist_iconimgsrc">';
				echo '</div>';
                echo     '</td>',
                '</tr>';
                break;
			case 'font':
				$val = $meta ? $meta : $field['std'];
				echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>','<input type="hidden" value="',$val,'" name="',$field['id'],'" id="',$field['id'],'">';
				 $fontarr = array("1","2","3","4","5","6","7","8","9","0","Q","W","E","R","T","Y","U","I","O","P","A","S","D","F","G","H","J","K","L","Z","X","C","V","B","N","M","q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m","~","+","-","*","/","=","%","!","@","#","$","^","&","(",")","{","}","[","]","\"","'",";",":","<",">","?","/","|","\\",",",".","`");
				echo '<div class="artist_fonticon"><ul class="artist_icon_setings">';
				for($i=0;$i<count($fontarr);$i++){
					if($val == $fontarr[$i]){
						$cls = 'artist_selected_icon';
					}else{
						$cls = '';
					}
					echo '<li class="'.$cls.'"><i class="artist_backend_icon">'.$fontarr[$i].'</i></li>';
				}
				echo '</ul></div>';
                echo '</td>';
				break;
				case 'blank':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<div style="width:100%; text-align: center;">Or <a class="artist_tooltip"><i class="artist_info_icon">[</i>','<span><img class="callout" src="'.ARTIST_PATH.'/images/callout.gif" />
      Icon will have the high priority then the Uploaded Image.</span>','</a></div></td>';
				break;
        }
    }
    echo '</table>';
}
add_action('save_post', 'section_saveservices_options');
// save metadata
function section_saveservices_options($post_id)
{
    global $servicessection_option_meta,$post;
    $new = '';
    // verify nonce
    if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
        return $post_id;
    }
    // check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    if (defined('DOING_AJAX') && DOING_AJAX)
        return;
    // check permissions
    if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) {
            return $post_id;
        }
    } elseif (!current_user_can('edit_post', $post_id)) {
        return $post_id;
    }
    foreach ($servicessection_option_meta['fields'] as $field) {
        $old = get_post_meta($post_id, $field['id'], true);
        if (isset($_POST[$field['id']])) {
            $new = $_POST[$field['id']];
           // echo $new;
        }
        if ($new && $new != $old) {
            update_post_meta($post_id, $field['id'], $new);
			
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id, $field['id'], $old);
        }
    }
}   
/*
 * End Services MetaBox Option
 */
/*
 * Start Portfolio MetaBox Option
 */
$portfoliossection_option_meta = array(
    'id' => 'portfoliospage-section-meta',
    'title' => __('Portfolio section settings','artist'),
    'page' => 'portfolio',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
       /*array(
            'name' => __('Time', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'portfolio_time',
            "type" => "text",
            'std' => ''
        ),*/
		array(
            'name' => __('Portfolio Client', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'portfolio_client',
            "type" => "text",
            'std' => ''
        ),
		array(
            'name' => __('Show No. Of Related Post', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'portfolio_relatedpost',
            "type" => "text",
            'std' => ''
        ),
		/*array(
            'name' => __('Date', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'portfolio_date',
            "type" => "text",
            'std' => ''
        ),*/
		array(
			'name' => __('Portfolio Description', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'portfolio_description',
            "type" => "textarea",
            'std' => ''
		)
	)		
);
// create boxes for home sections
add_action('admin_menu', 'add_portfolio_section_meta_boxes');
function add_portfolio_section_meta_boxes(){
    global  $portfoliossection_option_meta;
    add_meta_box($portfoliossection_option_meta['id'], $portfoliossection_option_meta['title'], 'portfolio_show_section_options', $portfoliossection_option_meta['page'], $portfoliossection_option_meta['context'], $portfoliossection_option_meta['priority']);
} 
function portfolio_show_section_options(){
    global $portfoliossection_option_meta, $post;
    // Use nonce for verification
    echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
    echo '<table class="form-table">';
    foreach ($portfoliossection_option_meta['fields'] as $field) {
        // get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        switch ($field['type']) {
            case 'text':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
                    : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
			case 'textarea':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                $args = array(
					'textarea_rows' => 5,
					'media_buttons' => false,
					'teeny' => true,
					'quicktags' => false
				);
				wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                break;
        }
    }
    echo '</table>';
}
add_action('save_post', 'section_saveportfolio_options');
// save metadata
function section_saveportfolio_options($post_id)
{
    global $portfoliossection_option_meta,$post;
    $new = '';
    // verify nonce
    if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
        return $post_id;
    }
    // check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    if (defined('DOING_AJAX') && DOING_AJAX)
        return;
    // check permissions
    if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) {
            return $post_id;
        }
    } elseif (!current_user_can('edit_post', $post_id)) {
        return $post_id;
    }
    foreach ($portfoliossection_option_meta['fields'] as $field) {
        $old = get_post_meta($post_id, $field['id'], true);
        if (isset($_POST[$field['id']])) {
            $new = $_POST[$field['id']];
           // echo $new;
        }
        if ($new && $new != $old) {
            update_post_meta($post_id, $field['id'], $new);
			
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id, $field['id'], $old);
        }
    }
}   
/*
 * End Portfolio MetaBox Option
 */
/*
 * Start Testimonial MetaBox Option
 */
$testimonialssection_option_meta = array(
    'id' => 'testimonialpage-section-meta',
    'title' => __('Testimonial section settings','artist'),
    'page' => 'testimonial',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('Name', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'testimonial_name',
            "type" => "text",
            'std' => ''
        ),
		array(
            'name' => __('Designation', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'testimonial_designation',
            "type" => "text",
            'std' => ''
        ),
		array(
            'name' => __('Upload Image', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'testimonial_imageurl',
            "type" => "text",
            'std' => ''
        ),
        array(
            'name' => '',
            'desc' => '',
            'id' => $prefix.'testimonial_image_button',
            'type' => 'button'
        ),
       array(
            'name' => __('Description', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'testimonial_description',
            "type" => "textarea",
            'std' => ''
        )
	)		
);
// create boxes for home sections
add_action('admin_menu', 'add_testimonial_section_meta_boxes');
function add_testimonial_section_meta_boxes(){
    global  $testimonialssection_option_meta;
    add_meta_box($testimonialssection_option_meta['id'], $testimonialssection_option_meta['title'], 'testimonial_show_section_options', $testimonialssection_option_meta['page'], $testimonialssection_option_meta['context'], $testimonialssection_option_meta['priority']);
} 
function testimonial_show_section_options(){
    global $testimonialssection_option_meta, $post;
    // Use nonce for verification
    echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
    echo '<table class="form-table">';
    foreach ($testimonialssection_option_meta['fields'] as $field) {
        // get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        switch ($field['type']) {
			case 'text':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
                    : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
            case 'button':
                echo '<input style="float: left;" type="button" class="button" name="', $field['id'], '" id="', $field['id'], '" value="Upload" />';
				echo '<div style="float: right;margin-top: -40px;">';
				if(!empty($meta))
					echo '<img src="'.$meta.'" width="50" height="50" class="artist_iconimgsrc">';
				echo '</div>';
                echo     '</td>',
                '</tr>';
                break;
            case 'textarea':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                $args = array(
					'textarea_rows' => 5,
					'media_buttons' => false,
					'teeny' => true,
					'quicktags' => false
				);
				wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                break;
        }
    }
    echo '</table>';
}
add_action('save_post', 'section_savetestimonial_options');
// save metadata
function section_savetestimonial_options($post_id)
{
    global $testimonialssection_option_meta,$post;
    $new = '';
    // verify nonce
    if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
        return $post_id;
    }
    // check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    if (defined('DOING_AJAX') && DOING_AJAX)
        return;
    // check permissions
    if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) {
            return $post_id;
        }
    } elseif (!current_user_can('edit_post', $post_id)) {
        return $post_id;
    }
    foreach ($testimonialssection_option_meta['fields'] as $field) {
        $old = get_post_meta($post_id, $field['id'], true);
        if (isset($_POST[$field['id']])) {
            $new = $_POST[$field['id']];
           // echo $new;
        }
        if ($new && $new != $old) {
            update_post_meta($post_id, $field['id'], $new);
			
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id, $field['id'], $old);
        }
    }
} 
/*
 * End Testimonial MetaBox Option
 */
/*
 *	Start Post MetaBoxes
 */
$postsection_option_meta = array(
    'id' => 'postpage-section-meta',
    'title' => __('Sharing settings','artist'),
    'page' => 'post',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('Show No. Of Related Post', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'post_relatedpost',
            "type" => "text",
            'std' => ''
        ),
       array(
            'name' => __('Select Sharing Buttton', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'post_button',
            "type" => "checkbox",
            'std' => '',
			'options' => array(
							'facebook' => 'facebook',	
							'twitter' => 'Twitter',	
							'linkdin' => 'Linkdin',	
							'googleplus' => 'google plus',	
						),
        ),
		array(
            'name' => __('Related Text', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'postrelatedtext',
            "type" => "textarea",
            'std' => 'Insert Text HERE..'
        )
	)		
);
add_action('admin_menu', 'add_post_section_meta_boxes');
function add_post_section_meta_boxes(){
    global  $postsection_option_meta;
    add_meta_box($postsection_option_meta['id'], $postsection_option_meta['title'], 'post_show_section_options', $postsection_option_meta['page'], $postsection_option_meta['context'], $postsection_option_meta['priority']);
} 
function post_show_section_options(){
    global $postsection_option_meta, $post;
    // Use nonce for verification
    echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
    echo '<table class="form-table">';
    foreach ($postsection_option_meta['fields'] as $field) {
        // get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        switch ($field['type']) {
			case 'text':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
                    : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
			case 'checkbox':
				echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';

                foreach ($field['options'] as $key => $option) {
				 $meta = get_post_meta($post->ID, $key, true);
					echo'<input type="checkbox" name="' . $key . '"';
                    if ($meta == $key) {
                        echo 'checked';
                    }
                    echo' value="'.$key.'">' . $option . '<br>' ;
                }
			break;
            case 'textarea':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
				$args = array(
					'textarea_rows' => 5,
					'media_buttons' => false,
					'teeny' => true,
					'quicktags' => false
				);
				wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                break;
        }
    }
    echo '</table>';
}
add_action('save_post', 'section_savepost_options');
// save metadata
function section_savepost_options($post_id)
{
    global $postsection_option_meta,$post;
    $new = '';
    // verify nonce
    if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
        return $post_id;
    }
    // check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    if (defined('DOING_AJAX') && DOING_AJAX)
        return;
    // check permissions
    if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) {
            return $post_id;
        }
    } elseif (!current_user_can('edit_post', $post_id)) {
        return $post_id;
    }
    foreach ($postsection_option_meta['fields'] as $field) {
        $old = get_post_meta($post_id, $field['id'], true);
        if (isset($_POST[$field['id']])) {
            $new = $_POST[$field['id']];
           // echo $new;
        }
        if ($new && $new != $old) {
            update_post_meta($post_id, $field['id'], $new);
			
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id, $field['id'], $old);
        }
    }
	$arr = array('facebook' => 'facebook',	'twitter' => 'Twitter',	'linkdin' => 'Linkdin',				'googleplus' => 'google plus');
	foreach ($arr as $key => $option) {
		$old = get_post_meta($post_id, $key, true);
        if (isset($_POST[$key])) {
            $new = $_POST[$key];
           // echo $new;
        }
        if ($new && $new != $old) {
            update_post_meta($post_id, $key, $new);
			
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id, $key, $old);
        }
	}
}
/*
 *	End Post MetaBoxes
 */
/* 
 * Start Team Metabox
 */
$team_option_meta = array(
    'id' => 'team-meta',
    'title' => __('Team home section setting','artist'),
    'page' => 'team',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
        array(
            'name' => __('Member name', 'artist'),
            'desc' => __('Enter member name', 'artist'),
            'id' => $prefix.'team_name',
            "type" => "text",
            'std' => ''
        ),
        array(
            'name' => __('Member position', 'artist'),
            'desc' => __('Enter member position', 'artist'),
            'id' => $prefix.'team_position',
            "type" => "text",
            'std' => ''
        ),
		array(
            'name' => __('Description', 'artist'),
            'desc' => __('', 'artist'),
            'id' => $prefix.'team_decription',
            "type" => "textarea",
            'std' => ''
        ),
        array(
            'name' => __('Member photo', 'artist'),
            'desc' => __('Upload a member photo image (Must use 400x400 or above).', 'artist'), 
            'id' => $prefix.'team_image',
            "type" => "text",
            'std' => ''
        ),
		array(
            'name' => '',
            'desc' => '',
            'id' => $prefix.'team_image_button',
            'type' => 'button',
            'std' => 'Browse'  
        ),
        array(
            'name' => __('Facebook link', 'artist'),
            'desc' => __('Enter Facebook link', 'artist'),
            'id' => $prefix.'team_Facebook',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_Facebook_show',
            "type" => "social",
            'val' => 'facebook' 
        ),
        array(
            'name' => __('Twitter link', 'artist'),
            'desc' => __('Enter Twitter link', 'artist'),
            'id' => $prefix.'team_Twitter',
            "type" => "text",
            'std' => ''
        ),
		array(
            'id' => $prefix.'team_Twitter_show',
            "type" => "social",
            'val' => 'twitter' 
        ),
		array(
            'name' => __('Linkdin link', 'artist'),
            'desc' => __('Enter Linkdin link', 'artist'),
            'id' => $prefix.'team_linkdin',
            "type" => "text",
            'std' => ''
        ),
		array(
            'id' => $prefix.'team_linkdin_show',
            "type" => "social",
            'val' => 'linkdin' 
        ),
		array(
            'name' => __('Flickr link', 'artist'),
            'desc' => __('Enter flickr link', 'artist'),
            'id' => $prefix.'team_flickr',
            "type" => "text",
            'std' => ''
        ),
		array(
            'id' => $prefix.'team_flickr_show',
            "type" => "social",
            'val' => 'flickr' 
        ),
		array(
            'name' => __('Youtube link', 'artist'),
            'desc' => __('Enter youtube link', 'artist'),
            'id' => $prefix.'team_youtube',
            "type" => "text",
            'std' => ''
        ),
		array(
            'id' => $prefix.'team_youtube_show',
            "type" => "social",
            'val' => 'youtube' 
        ),
		array(
            'name' => __('Redirect Url', 'artist'),
            'id' => $prefix.'team_redirect_url',
            "type" => "text",
            'std' => ''
        ),
        array(
            'name' => '',
            'desc' => '',
            'id' => $prefix.'team_clear_fields',
            'type' => 'button-clear',
            'std' => 'Clear Meta'
        )
    )
);
// create boxes for team
add_action('admin_menu', 'add_team_meta_boxes');
function add_team_meta_boxes()
{
    global  $team_option_meta;
    add_meta_box($team_option_meta['id'], $team_option_meta['title'], 'show_team_options', $team_option_meta['page'], $team_option_meta['context'], $team_option_meta['priority']);
}
function show_team_options()
{
    global $team_option_meta, $post;
    // Use nonce for verification
    echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
    echo '<table class="form-table">';
    foreach ($team_option_meta['fields'] as $field) {
        // get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        switch ($field['type']) {
            case 'text':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
                    : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
			case 'social':
                echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '" value="',$field['val'] , '" ';
				if(isset($meta) && $meta == $field['val']){
					echo ' checked ';
				}
				echo '/>';
                break;
            case 'button':
                echo '<input style="float: left;" type="button" class="button" name="', $field['id'], '" id="', $field['id'], '" value="Browse" />';
                echo     '</td>',
                '</tr>';
                break;
            case 'button-clear':
                echo '<tr><td colspan="2"><input style="float: right;" type="button" class="button" name="', $field['id'], '" id="', $field['id'], '" value="Clear Meta" />';
                ?>
                <script type="text/javascript">
                    jQuery(document).ready(function($){
                        $('#<?php echo esc_js( $field['id'] ); ?>').click(function(){
                            if(confirm("Are you sure you want to clear fields?")){
                                 $('#<?php echo esc_js ( $team_option_meta['id'] ); ?> input[type="text"]').val('');
                             }
                        });
                    });
                </script>
                <?php
                echo     '</td>',
                '</tr>';
                break;
            case 'select':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo'<select name="' . $field['id'] . '">';
                foreach ($field['options'] as $option) {
                    echo'<option';
                    if ($meta == $option) {
                        echo ' selected="selected"';
                    }
                    echo'>' . $option . '</option>';
                }
                echo'</select>';
                break;
            case 'select-custom':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo'<select name="' . $field['id'] . '">';
                foreach ($field['options'] as $key => $option) {
                    echo'<option';
                    if ($meta == $key) {
                        echo ' selected="selected"';
                    }
                    echo' value="'.$key.'">' . $option . '</option>';
                }
                echo'</select>';
                break;
			case 'textarea':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
				$args = array(
					'textarea_rows' => 5,
					'media_buttons' => false,
					'teeny' => true,
					'quicktags' => false
				);
				wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                break;
        }
    }
    echo '</table>';
}
add_action('save_post', 'team_save_options');
// save team metadata
function team_save_options($post_id)
{
    global $team_option_meta;
    $new = '';
    // verify nonce
    if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
        return $post_id;
    }
    // check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    if (defined('DOING_AJAX') && DOING_AJAX)
        return;
    // check permissions
    if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) {
            return $post_id;
        }
    } elseif (!current_user_can('edit_post', $post_id)) {
        return $post_id;
    }
 
    foreach ($team_option_meta['fields'] as $field) {
        $old = get_post_meta($post_id, $field['id'], true);
        if (isset($_POST[$field['id']])) {
            $new = $_POST[$field['id']];
        }
        if ($new && $new != $old) {
            update_post_meta($post_id, $field['id'], $new);
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id, $field['id'], $old);
        }
    }
	
	if(!isset($_POST['artist_team_Facebook_show'])){
		$old = get_post_meta($post_id, 'artist_team_Facebook_show', true);
		delete_post_meta($post_id, 'artist_team_Facebook_show', $old);
	}
	if(!isset($_POST['artist_team_Twitter_show'])){
		$old = get_post_meta($post_id, 'artist_team_Twitter_show', true);
		delete_post_meta($post_id, 'artist_team_Twitter_show', $old);
	}
	if(!isset($_POST['artist_team_linkdin_show'])){
		$old = get_post_meta($post_id, 'artist_team_linkdin_show', true);
		delete_post_meta($post_id, 'artist_team_linkdin_show', $old);
	}
	if(!isset($_POST['artist_team_flickr_show'])){
		$old = get_post_meta($post_id, 'artist_team_flickr_show', true);
		delete_post_meta($post_id, 'artist_team_flickr_show', $old);
	}
	if(!isset($_POST['artist_team_youtube_show'])){
		$old = get_post_meta($post_id, 'artist_team_youtube_show', true);
		delete_post_meta($post_id, 'artist_team_youtube_show', $old);
	}
}
/*
 *	End Team MetaBoxes
 */
/*
 *	Start Page MetaBox
 */
$page_option_meta = array(
    'id' => 'page-meta',
    'title' => __('Sidebar Setting','artist'),
    'page' => 'page',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		 array(
            'name' => 'Choose Sidebar Postion For This Section',
            'desc' => '',
            'id' => $prefix.'page_sidebarposition',
            'type' => 'sidebarradio',
            'std' => 'full',
			'option' => array(
					'full' => ARTIST_PATH.'/images/admin/1col.png',
					'left' => ARTIST_PATH.'/images/admin/2cl.png',
					'right' => ARTIST_PATH.'/images/admin/2cr.png'
				)
        )
	)
       
);
// create boxes for team
add_action('admin_menu', 'add_page_meta_boxes');
function add_page_meta_boxes()
{
    global  $page_option_meta;
    add_meta_box($page_option_meta['id'], $page_option_meta['title'], 'show_page_options', $page_option_meta['page'], $page_option_meta['context'], $page_option_meta['priority']);
}
function show_page_options()
{
    global $page_option_meta, $post;
    // Use nonce for verification
    echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
    echo '<table class="form-table">';
    foreach ($page_option_meta['fields'] as $field) {
        // get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        switch ($field['type']) {
            case 'sidebarradio':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
				if(empty($meta)){
					$meta = 'full';
				}
				foreach($field['option'] as $k=>$v){
					echo '<div class="', ($meta == $k) ? 'artist_chooseborder '
                    : '' ,'artist-select-sidebar">
					<div style="display:none;">
					<input type="radio" value="'.$k.'" ',($meta == $k) ? 'checked'
                    : '','  name="'.$field['id'].'" ></div>';
					echo '<img src="'.$v.'" ></div>';
				}
                break;
        }
    }
    echo '</table>';
				?>
				<script>
				jQuery(document).ready(function(){
					jQuery('.artist-select-sidebar').click(function(){
						jQuery('.artist-select-sidebar').find('input').removeAttr('checked');
						jQuery('.artist-select-sidebar').removeClass('artist_chooseborder');
						jQuery(this).find('input').attr('checked','checked');
						jQuery(this).addClass('artist_chooseborder');
					});
				});
				</script>
				<?php
}
add_action('save_post', 'page_save_options');
// save team metadata
function page_save_options($post_id)
{
    global $page_option_meta;
    $new = '';
    // verify nonce
    if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
        return $post_id;
    }
    // check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }
    if (defined('DOING_AJAX') && DOING_AJAX)
        return;
    // check permissions
    if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) {
            return $post_id;
        }
    } elseif (!current_user_can('edit_post', $post_id)) {
        return $post_id;
    }
 
    foreach ($page_option_meta['fields'] as $field) {
        $old = get_post_meta($post_id, $field['id'], true);
        if (isset($_POST[$field['id']])) {
             $new = $_POST[$field['id']];
        }
        if ($new && $new != $old) {
            update_post_meta($post_id, $field['id'], $new);
        } elseif ('' == $new && $old) {
            delete_post_meta($post_id, $field['id'], $old);
        }
    }
}
/*
 *	End Page MetaBox
 */
?>