<?php
/*
 * Start Social widget
 */
class social_Widget extends WP_Widget {
	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'social_Widget',
			__('Artist Social', 'artist'), // Name
			array( 'description' => __( 'Footer Social Widget', 'artist' ), 'artist') // Args
		);
	}
	public function widget( $args, $instance ) {
		global $artist_data;
		$title = $instance['artist_title'];
		$desc = $instance['artist_description'];
		$fb = $instance['artist_fb'];
		$twt = $instance['artist_twt'];
		$linkdin = $instance['artist_linkdin'];
		$flikr = $instance['artist_flikr'];
		$youtube = $instance['artist_youtube'];
		$dribbble = $instance['artist_dribbble'];
		$delicious = $instance['artist_delicious'];
		echo $args['before_widget'];
		echo '<div class="span12 wow fadeInLeft">
	<h1 class="lined"> '.esc_attr ( $title ).' </h1>
  </div>
  <div class="span12 hs_left hs_footer_tagline"> '.esc_attr ( $desc ).' </div>
  <div class="span12 hs_social_area"><ul class="hs_footer_menu">';
		if(!empty($fb))
			echo '<li class="wow swing"> <a href="'.esc_url( $artist_data['artist_facebookurl'] ).'" class="hs_footer_facebook" target="blank"> </a> </li>';
		if(!empty($twt))
			echo '<li class="wow swing hs_delay_01"> <a href="'.esc_url( $artist_data['artist_twitterurl'] ).'" class="hs_footer_twitter" target="blank"> </a> </li>';
		if(!empty($linkdin))	
			echo '<li class="wow swing hs_delay_02"> <a href="'.esc_url( $artist_data['artist_linkedinurl'] ).'" class="hs_footer_linkedin" target="blank"> </a> </li>';
		if(!empty($flikr))
			echo '<li class="wow swing hs_delay_03"> <a href="'.esc_url( $artist_data['artist_flickrurl'] ).'" class="hs_footer_flickr" target="blank"> </a> </li>';
		if(!empty($youtube))
			echo '<li class="wow swing hs_delay_04"> <a href="'.esc_url( $artist_data['artist_youtubeurl'] ).'" class="hs_footer_youtube" target="blank"> </a> </li>';
		if(!empty($dribbble))
			echo '<li class="wow swing hs_delay_05"> <a href="'.esc_url( $artist_data['artist_dribbbleurl'] ).'" class="hs_footer_dribbble" target="blank"> </a> </li>';
		if(!empty($delicious))
			echo '<li class="wow swing hs_delay_06"> <a href="'.esc_url( $artist_data['artist_deliciousurl'] ).'" class="hs_footer_delicious" target="blank"> </a> </li>';
        echo '</ul></div>';
		echo $args['after_widget'];
	}
	public function form( $instance ) {
		if( isset($instance['artist_fb']) || isset($instance['artist_twt']) ||
			isset($instance['artist_linkdin']) || isset($instance['artist_flikr']) ||
			isset($instance['artist_youtube']) || isset($instance['artist_dribbble']) ||
			isset($instance['artist_delicious'])|| isset($instance['artist_title']) ||
			isset($instance['artist_description'])
			)
		{
			$title = esc_attr( $instance['artist_title'] );
			$desc = esc_attr( $instance['artist_description'] );
			$fb = $instance['artist_fb'];
			$twt = $instance['artist_twt'];
			$linkdin = $instance['artist_linkdin'];
			$flikr = $instance['artist_flikr'];
			$youtube = $instance['artist_youtube'];
			$dribbble = $instance['artist_dribbble'];
			$delicious = $instance['artist_delicious'];
		}
		else {
			$title = '';
			$desc = '';
			$fb = '';
			$twt = '';
			$linkdin = '';
			$flikr = '';
			$youtube = '';
			$dribbble = '';
			$delicious = '';
		}
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo 'Title:'; ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_title' ); ?>" name="<?php echo $this->get_field_name( 'artist_title' ); ?>" type="text" value="<?php echo $title; ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'Description' ); ?>"><?php echo 'Description:'; ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_description' ); ?>" name="<?php echo $this->get_field_name( 'artist_description' ); ?>" type="text" value="<?php echo $desc; ?>">
		</p>
		<p>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_fb' ); ?>" name="<?php echo $this->get_field_name( 'artist_fb' ); ?>" type="checkbox" value="facebook" <?php if($fb == 'facebook'){ echo 'checked'; } ?> > Facebook
		</p>
		<p>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_twt' ); ?>" name="<?php echo $this->get_field_name( 'artist_twt' ); ?>" type="checkbox" value="Twitter" <?php if($twt == 'Twitter'){ echo 'checked'; } ?> > Twitter 
		</p>
		<p>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_linkdin' ); ?>" name="<?php echo $this->get_field_name( 'artist_linkdin' ); ?>" type="checkbox" value="Linkedin" <?php if($linkdin == 'Linkedin'){ echo 'checked'; } ?> > Linkedin 
		</p>
		<p>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_flikr' ); ?>" name="<?php echo $this->get_field_name( 'artist_flikr' ); ?>" type="checkbox" value="Flickr" <?php if($flikr == 'Flickr'){ echo 'checked'; } ?> > Flickr  
		</p>
		<p>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_youtube' ); ?>" name="<?php echo $this->get_field_name( 'artist_youtube' ); ?>" type="checkbox" value="Youtube" <?php if($youtube == 'Youtube'){ echo 'checked'; } ?> > Youtube  
		</p>
		<p>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_dribbble' ); ?>" name="<?php echo $this->get_field_name( 'artist_dribbble' ); ?>" type="checkbox" value="Dribbble" <?php if($dribbble == 'Dribbble'){ echo 'checked'; } ?> > Dribbble  
		</p>
		<p>
		<input class="widefat" id="<?php echo $this->get_field_id( 'artist_delicious' ); ?>" name="<?php echo $this->get_field_name( 'artist_delicious' ); ?>" type="checkbox" value="Delicious" <?php if($delicious == 'Delicious'){ echo 'checked'; } ?> > Delicious   
		</p>
	<?php 
	}
		/*
	 * Sanitize widget form values as they are saved.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['artist_title'] = (!empty($new_instance['artist_title']))?strip_tags($new_instance['artist_title']):'';
		$instance['artist_description'] = (!empty($new_instance['artist_description']))?strip_tags($new_instance['artist_description']):'';
		$instance['artist_fb'] = (!empty($new_instance['artist_fb']))?strip_tags($new_instance['artist_fb']):'';
		$instance['artist_twt'] = (!empty($new_instance['artist_twt']))?strip_tags($new_instance['artist_twt']):'';
		$instance['artist_linkdin'] = (!empty($new_instance['artist_linkdin']))?strip_tags($new_instance['artist_linkdin']):'';
		$instance['artist_flikr'] = (!empty($new_instance['artist_flikr']))?strip_tags($new_instance['artist_flikr']):'';
		$instance['artist_youtube'] = (!empty($new_instance['artist_youtube']))?strip_tags($new_instance['artist_youtube']):'';
		$instance['artist_dribbble'] = (!empty($new_instance['artist_dribbble']))?strip_tags($new_instance['artist_dribbble']):'';
		$instance['artist_delicious'] = (!empty($new_instance['artist_delicious']))?strip_tags($new_instance['artist_delicious']):'';
		return $instance;
	}
}
// register Foo_Widget widget
function register_social_widgets() {
    register_widget( 'social_Widget' );
}
add_action( 'widgets_init', 'register_social_widgets' );
/*
 * End Social widget
 */
?>